/*
 * Decompiled with CFR 0.152.
 */
package net.dzzd.core;

import net.dzzd.access.ITexture;
import net.dzzd.core.Drawer;
import net.dzzd.core.SceneObject;

public class Texture
extends SceneObject
implements ITexture {
    public static final long serialVersionUID = 1L;
    int width = 1;
    int height = 1;
    int decalWidth = 0;
    int decalHeight;
    int maskWidth = 1;
    int maskHeight = 1;
    int[] pixels = null;
    int[][] mipMap = new int[32][];
    int nbMipMap = 0;
    int type = 1;
    boolean alphaChannelEnabled;

    Texture() {
    }

    public Texture(int n, int n2) {
        this();
        this.setSize(n, n2);
        this.pixels = new int[this.width * this.height];
    }

    public void setSize(int n, int n2) {
        this.decalWidth = 0;
        this.width = 1;
        while (this.width < n) {
            this.width <<= 1;
            ++this.decalWidth;
        }
        this.maskWidth = this.width - 1;
        this.decalHeight = 0;
        this.height = 1;
        while (this.height < n2) {
            this.height <<= 1;
            ++this.decalHeight;
        }
        this.maskHeight = this.height - 1;
    }

    public void setType(int n) {
        this.type = n;
    }

    public int getType() {
        return this.type;
    }

    public void build() {
        super.build();
        if (this.type == 3 || this.type == 4) {
            this.buildMipMap();
            if (this.isGrey()) {
                System.out.println("Texture bump d\u00e9tect\u00e9");
                this.buildNormal();
            } else {
                System.out.println("Texture normale d\u00e9tect\u00e9");
                this.type = 3;
            }
            this.normalize();
        } else {
            this.buildMipMap();
        }
    }

    private boolean isGrey() {
        boolean bl = true;
        int n = this.width;
        int n2 = this.height;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n3 = j + i * n;
                int n4 = this.pixels[n3];
                int n5 = n4 >> 16 & 0xFF;
                int n6 = n4 >> 8 & 0xFF;
                int n7 = n4 & 0xFF;
                if (n5 == n6 && n5 == n7) continue;
                bl = false;
            }
        }
        return bl;
    }

    public void buildNormal() {
        int n = this.maskWidth;
        int n2 = this.maskHeight;
        int[] nArray = this.pixels;
        int[] nArray2 = new int[this.pixels.length];
        int n3 = this.width;
        int n4 = this.height;
        for (int i = 0; i < this.nbMipMap; ++i) {
            int n5;
            int n6;
            int n7;
            for (n7 = 0; n7 < n4; ++n7) {
                for (n6 = 0; n6 < n3; ++n6) {
                    n5 = n6 + n7 * n3;
                    nArray2[n5] = nArray[n5] << 8;
                }
            }
            for (n7 = 0; n7 < n4; ++n7) {
                for (n6 = 0; n6 < n3; ++n6) {
                    n5 = (n6 - 1 & n) + (n7 - 1 & n2) * n3;
                    int n8 = (n6 & n) + (n7 - 1 & n2) * n3;
                    int n9 = (n6 + 1 & n) + (n7 - 1 & n2) * n3;
                    int n10 = (n6 - 1 & n) + (n7 & n2) * n3;
                    int n11 = (n6 & n) + (n7 & n2) * n3;
                    int n12 = (n6 + 1 & n) + (n7 & n2) * n3;
                    int n13 = (n6 - 1 & n) + (n7 + 1 & n2) * n3;
                    int n14 = (n6 & n) + (n7 + 1 & n2) * n3;
                    int n15 = (n6 + 1 & n) + (n7 + 1 & n2) * n3;
                    int n16 = nArray2[n5] >> 24 & 0xFF;
                    int n17 = nArray2[n8] >> 24 & 0xFF;
                    int n18 = nArray2[n9] >> 24 & 0xFF;
                    int n19 = nArray2[n10] >> 24 & 0xFF;
                    int n20 = nArray2[n11] >> 24 & 0xFF;
                    int n21 = nArray2[n12] >> 24 & 0xFF;
                    int n22 = nArray2[n13] >> 24 & 0xFF;
                    int n23 = nArray2[n14] >> 24 & 0xFF;
                    int n24 = nArray2[n15] >> 24 & 0xFF;
                    int n25 = n20 - n16;
                    int n26 = n20 - n17;
                    int n27 = n20 - n18;
                    int n28 = n20 - n19;
                    int n29 = n20 - n21;
                    int n30 = n20 - n22;
                    int n31 = n20 - n23;
                    int n32 = n20 - n24;
                    int n33 = n29 + (n27 + n32 >> 1) - (n28 + (n25 + n26 >> 1));
                    int n34 = -(n31 + (n30 + n32 >> 1) - (n26 + (n25 + n27 >> 1)));
                    int n35 = 127 - (Math.abs((n33 >>= 1) + (n34 >>= 1)) >> 1);
                    n34 += 128;
                    n35 += 128;
                    if ((n33 += 128) > 255) {
                        n33 = 255;
                    }
                    if (n34 > 255) {
                        n34 = 255;
                    }
                    if (n35 > 255) {
                        n35 = 255;
                    }
                    if (n33 < 0) {
                        n33 = 0;
                    }
                    if (n34 < 0) {
                        n34 = 0;
                    }
                    if (n35 < 0) {
                        n35 = 0;
                    }
                    int n36 = nArray2[n11] & 0xFF000000;
                    nArray[n11] = n36 | n33 << 16 | n34 << 8 | n35;
                }
            }
            nArray = this.mipMap[i];
            n3 >>= 1;
            n4 >>= 1;
            n >>= 1;
            n2 >>= 1;
        }
    }

    public void normalize() {
        int[] nArray = this.pixels;
        int n = this.width;
        int n2 = this.height;
        for (int i = 0; i < this.nbMipMap; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n; ++k) {
                    int n3 = k + j * n;
                    int n4 = nArray[n3];
                    int n5 = (n4 & 0xFF) - 128;
                    int n6 = (n4 >> 8 & 0xFF) - 128;
                    int n7 = (n4 >> 16 & 0xFF) - 128;
                    int n8 = n4 & 0xFF000000;
                    int n9 = Drawer.normalMap[n7 * n7 + n6 * n6 + n5 * n5];
                    n7 *= n9;
                    n6 *= n9;
                    n5 *= n9;
                    n7 >>= 19;
                    n6 >>= 19;
                    n5 >>= 19;
                    n6 += 128;
                    n5 += 128;
                    if ((n7 += 128) > 255) {
                        n7 = 255;
                    }
                    if (n6 > 255) {
                        n6 = 255;
                    }
                    if (n5 > 255) {
                        n5 = 255;
                    }
                    if (n7 < 0) {
                        n7 = 0;
                    }
                    if (n6 < 0) {
                        n6 = 0;
                    }
                    if (n5 < 0) {
                        n5 = 0;
                    }
                    nArray[n3] = n8 | n7 << 16 | n6 << 8 | n5;
                }
            }
            nArray = this.mipMap[i];
            n >>= 1;
            n2 >>= 1;
        }
    }

    public void buildMipMap() {
        int n = this.width >> 1;
        int[] nArray = this.pixels;
        for (int i = this.height >> 1; n > 1 && i > 1; n >>= 1, i >>= 1) {
            int[] nArray2 = new int[n * i];
            for (int j = 0; j < i; ++j) {
                for (int k = 0; k < n; ++k) {
                    int n2 = (k << 1) + (j << 1) * (n << 1);
                    int n3 = k + j * n;
                    int n4 = 0;
                    int n5 = nArray[n2];
                    int n6 = nArray[n2 + 1];
                    int n7 = nArray[n2 + (n << 1)];
                    int n8 = nArray[n2 + (n << 1) + 1];
                    int n9 = (n5 & 0xFEFEFE) + (n6 & 0xFEFEFE) >> 1;
                    int n10 = (n7 & 0xFEFEFE) + (n8 & 0xFEFEFE) >> 1;
                    n4 = (n9 & 0xFEFEFE) + (n10 & 0xFEFEFE) >> 1;
                    if (this.alphaChannelEnabled || this.type == 4) {
                        int n11 = n5 >> 24 & 0xFF;
                        int n12 = n6 >> 24 & 0xFF;
                        int n13 = n7 >> 24 & 0xFF;
                        int n14 = n8 >> 24 & 0xFF;
                        int n15 = n11 + n12 + n13 + n14 >> 2;
                        n4 |= n15 << 24;
                    }
                    nArray2[n3] = n4;
                }
            }
            this.mipMap[this.nbMipMap] = nArray2;
            ++this.nbMipMap;
            nArray = nArray2;
        }
    }

    public int getPixelsWidth() {
        return this.width;
    }

    public int getPixelsHeight() {
        return this.height;
    }

    public int[] getPixels() {
        return this.pixels;
    }

    public void setAlphaChannelEnabled(boolean bl) {
        this.alphaChannelEnabled = bl;
    }

    public boolean getAlphaChannelEnabled() {
        return this.alphaChannelEnabled;
    }
}

