/*
 * Decompiled with CFR 0.152.
 */
package net.dzzd.core;

import java.awt.Container;
import net.dzzd.DzzD;
import net.dzzd.Scene3DRenderCallBack;
import net.dzzd.access.IProgressListener;
import net.dzzd.access.IRender3D;
import net.dzzd.access.IScene3D;
import net.dzzd.access.IScene3DRender;
import net.dzzd.access.IScene3DRenderCallBack;
import net.dzzd.access.ITimer;
import net.dzzd.core.ProgressListener;
import net.dzzd.utils.Log;

public final class Scene3DRender
implements IScene3DRender,
Runnable {
    private ITimer iTimer = DzzD.newTimer();
    private long startTime;
    private boolean runProcess = false;
    private boolean pauseProcess = false;
    private Thread process = null;
    private int numLoop = 0;
    private int maxFPS100 = 4000;
    private long[] fpsBuffer = new long[50];
    private String renderSwitchName = null;
    private boolean autoPlayAnimator = false;
    private AsyncSwitchRender render3DSwitcher;
    private IScene3DRenderCallBack iScene3DRenderCallBack;
    private IRender3D renderSwitch;
    private IRender3D render = DzzD.newRender3D("SOFT", null);
    private IScene3D scene = DzzD.newScene3D();

    public Scene3DRender() {
        this.iScene3DRenderCallBack = new Scene3DRenderCallBack();
    }

    public void setScene3D(IScene3D iScene3D) {
        this.scene = iScene3D;
    }

    public void switchRender3D(String string) {
        if (this.render3DSwitcher != null) {
            return;
        }
        this.render3DSwitcher = new AsyncSwitchRender(string);
        Thread thread = new Thread(this.render3DSwitcher);
        thread.start();
    }

    public long getFrameTime() {
        return 0L;
    }

    public long getTime() {
        return this.iTimer.getTime();
    }

    public IScene3D getScene3D() {
        return this.scene;
    }

    public IRender3D getRender3D() {
        return this.render;
    }

    public void setScene3DRenderCallBack(IScene3DRenderCallBack iScene3DRenderCallBack) {
        this.iScene3DRenderCallBack = iScene3DRenderCallBack;
        if (this.iScene3DRenderCallBack != null) {
            this.iScene3DRenderCallBack.render3DstartCallBack(this);
        }
    }

    public void start() {
        if (this.process == null) {
            this.process = new Thread(this);
            try {
                this.process.setPriority(10);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            this.runProcess = true;
            this.process.start();
        }
        if (this.process != null) {
            this.runProcess = true;
            this.pauseProcess = false;
        }
    }

    public void pause() {
        this.pauseProcess = true;
    }

    public void stop() {
        this.pauseProcess = false;
        this.runProcess = false;
        if (this.process != null) {
            try {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    Log.log(interruptedException);
                }
                if (this.process != null) {
                    this.process.join();
                }
            }
            catch (InterruptedException interruptedException) {
                Log.log(interruptedException);
            }
            catch (NullPointerException nullPointerException) {
                Log.log(nullPointerException);
            }
            this.process = null;
        }
    }

    public void setMaxFPS100(int n) {
        this.maxFPS100 = n;
    }

    public int getFPS100() {
        if (this.numLoop == 0) {
            return 0;
        }
        if (this.numLoop < this.fpsBuffer.length) {
            long l = this.fpsBuffer[0];
            if (this.fpsBuffer[this.numLoop] - l == 0L) {
                return 0;
            }
            return (int)(100000L * (long)this.numLoop / (this.fpsBuffer[this.numLoop] - l));
        }
        long l = this.fpsBuffer[(this.numLoop + 1) % this.fpsBuffer.length];
        if (this.iTimer.getTime() - l == 0L) {
            return 0;
        }
        return (int)(100000L * (long)(this.fpsBuffer.length - 1) / (this.fpsBuffer[this.numLoop % this.fpsBuffer.length] - l));
    }

    public void run() {
        Log.log("Start Scene3DRender: " + Thread.currentThread());
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        boolean bl = false;
        this.numLoop = 0;
        this.startTime = this.iTimer.getTime();
        try {
            while (this.runProcess) {
                if (!this.pauseProcess) {
                    l = this.iTimer.getTime() - this.startTime;
                    long l4 = 100000000 / this.maxFPS100;
                    long l5 = 1000L * l / l4;
                    long l6 = (l5 + 1L) * l4 / 1000L;
                    this.fpsBuffer[this.numLoop % this.fpsBuffer.length] = l + this.startTime;
                    this.render();
                    if (this.numLoop % 400 == 0) {
                        System.out.println(this.getFPS100() + "    " + this.numLoop + " /" + l5);
                    }
                    Thread.yield();
                    ++this.numLoop;
                    continue;
                }
                Thread.sleep(1L);
                Thread.yield();
            }
        }
        catch (InterruptedException interruptedException) {
            Log.log(interruptedException);
        }
        this.pauseProcess = false;
        this.runProcess = false;
        this.process = null;
        Log.log("Stop Scene3DRender: " + Thread.currentThread());
    }

    public void render() {
        if (this.render3DSwitcher != null && this.render3DSwitcher.getFinished()) {
            if (!this.render3DSwitcher.getError()) {
                IRender3D iRender3D = this.render3DSwitcher.getRender();
                Container container = this.render.getCanvas().getParent();
                if (container != null) {
                    container.remove(this.render.getCanvas());
                }
                if (container != null) {
                    container.add(iRender3D.getCanvas());
                }
                iRender3D.setSize(this.render.getWidth(), this.render.getHeight());
                iRender3D.getCanvas().requestFocus();
                this.render = iRender3D;
                Log.log("SWITCHED TO " + this.render.getImplementationName());
            }
            this.render3DSwitcher = null;
            this.iScene3DRenderCallBack.render3DSwitched(this);
        }
        this.iScene3DRenderCallBack.render3DStart(this);
        if (this.autoPlayAnimator) {
            this.scene.playScene3DObjectAnimator((int)(this.iTimer.getTime() - this.startTime));
        }
        this.scene.setScene3DObjectToWorld();
        this.iScene3DRenderCallBack.render3DWorldSpace(this);
        this.scene.setScene3DObjectToCamera();
        this.iScene3DRenderCallBack.render3DCameraSpace(this);
        this.render.setCamera3D(this.scene.getCurrentCamera3D());
        this.render.renderScene3D(this.scene);
        this.iScene3DRenderCallBack.render3DEnd(this);
        if (this.scene.getNbMonitoredSceneObject() != 0) {
            this.scene.updateMonitoredSceneObjects();
        }
    }

    public void setAutoPlayAnimator(boolean bl) {
        this.autoPlayAnimator = bl;
    }

    public boolean getAutoPlayAnimator() {
        return this.autoPlayAnimator;
    }

    private class AsyncSwitchRender
    extends ProgressListener
    implements Runnable,
    IProgressListener {
        IRender3D render;
        String render3DName;

        AsyncSwitchRender(String string) {
            this.render3DName = string;
            this.render = null;
            this.setProgress(0);
            this.setFinished(false);
            this.setError(false);
        }

        public IRender3D getRender() {
            return this.render;
        }

        public void run() {
            this.render = DzzD.newRender3D(this.render3DName, null);
            if (this.render == null) {
                this.setError(true);
                this.setProgress(100);
                this.setFinished(true);
                return;
            }
            this.setError(false);
            this.setProgress(100);
            this.setFinished(true);
        }
    }
}

