/*
 * Decompiled with CFR 0.152.
 */
package net.dzzd.core;

import java.io.Serializable;
import net.dzzd.access.IPoint3D;
import net.dzzd.access.IScene3DObjectAnimator;
import net.dzzd.access.ITimer;
import net.dzzd.core.Axis3D;
import net.dzzd.core.Point3D;
import net.dzzd.core.Timer;

public class Scene3DObjectAnimator
implements IScene3DObjectAnimator,
Serializable {
    public static final long serialVersionUID = 1L;
    private Axis3D axis3D;
    private Point3D position = new Point3D();
    private Point3D rotation = new Point3D();
    private KeyPosition firstKeyPosition = null;
    private int nbKeyPosition = 0;
    private KeyRotation firstKeyRotation = null;
    private int nbKeyRotation = 0;
    private KeyZoom firstKeyZoom = null;
    private int nbKeyZoom = 0;
    private transient ITimer timer;
    private long startTime = -1L;
    private long endTime = -1L;
    private long loopAt = -1L;
    private long pauseTime = -1L;

    public Scene3DObjectAnimator() {
        this.axis3D = new Axis3D();
        this.timer = new Timer();
    }

    public ITimer getTimer() {
        return this.timer;
    }

    public void setTimer(ITimer iTimer) {
        this.timer = iTimer;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getPauseTime() {
        return this.pauseTime;
    }

    public void loopAt(long l) {
        this.loopAt = l;
    }

    public void pause() {
        if (this.pauseTime != -1L) {
            return;
        }
        this.pauseTime = this.timer.getTime() - this.startTime;
        this.playAt((int)this.pauseTime);
    }

    public void resume() {
        if (this.pauseTime == -1L) {
            return;
        }
        this.startTime = this.timer.getTime() - this.pauseTime;
        this.pauseTime = 0L;
    }

    public void start() {
        this.pauseTime = -1L;
        this.endTime = -1L;
        this.startTime = this.timer.getTime();
    }

    public void start(long l) {
        this.pauseTime = -1L;
        this.endTime = -1L;
        this.startTime = this.timer.getTime() - l;
    }

    public void start(long l, long l2) {
        this.pauseTime = -1L;
        this.endTime = l2;
        this.startTime = this.timer.getTime() - l;
    }

    public void play() {
        if (this.startTime == -1L) {
            return;
        }
        long l = this.timer.getTime() - this.startTime;
        if (this.loopAt != -1L) {
            l %= this.loopAt;
        }
        if (this.pauseTime != -1L) {
            l = this.pauseTime;
        }
        if (this.endTime != -1L && l > this.endTime) {
            l = this.endTime;
        }
        this.playAt((int)l);
    }

    public void stop() {
        this.startTime = -1L;
        this.pauseTime = -1L;
    }

    public int addKey(KeyAnim keyAnim, KeyAnim keyAnim2) {
        if (keyAnim == null) {
            keyAnim = keyAnim2;
            return 0;
        }
        KeyAnim keyAnim3 = null;
        KeyAnim keyAnim4 = keyAnim;
        int n = 0;
        while (keyAnim4 != null && keyAnim4.getTime() <= keyAnim2.getTime()) {
            keyAnim3 = keyAnim4;
            keyAnim4 = keyAnim4.getNextKey();
            ++n;
        }
        if (keyAnim3 != null) {
            keyAnim3.setNextKey(keyAnim2);
        }
        keyAnim2.setNextKey(keyAnim4);
        return n;
    }

    public int addKeyPosition(int n, IPoint3D iPoint3D) {
        KeyPosition keyPosition = new KeyPosition(n, (Point3D)iPoint3D);
        ++this.nbKeyPosition;
        int n2 = this.addKey(this.firstKeyPosition, keyPosition);
        if (n2 == 0) {
            this.firstKeyPosition = keyPosition;
        }
        return n2;
    }

    public int addKeyRotation(int n, IPoint3D iPoint3D, IPoint3D iPoint3D2, double d) {
        KeyRotation keyRotation = new KeyRotation(n, (Point3D)iPoint3D, (Point3D)iPoint3D2, d);
        ++this.nbKeyRotation;
        int n2 = this.addKey(this.firstKeyRotation, keyRotation);
        if (n2 == 0) {
            this.firstKeyRotation = keyRotation;
        }
        return n2;
    }

    public void addKeyZoom(int n, IPoint3D iPoint3D, IPoint3D iPoint3D2) {
    }

    public KeyAnim getKeyAt(KeyAnim keyAnim, int n) {
        if (keyAnim == null) {
            return null;
        }
        KeyAnim keyAnim2 = null;
        int n2 = 0;
        for (KeyAnim keyAnim3 = keyAnim; keyAnim3 != null; keyAnim3 = keyAnim3.getNextKey()) {
            ++n2;
            if (keyAnim3.getTime() > n) break;
            keyAnim2 = keyAnim3;
        }
        return keyAnim2;
    }

    public void playRotationAt(int n) {
        KeyAnim keyAnim = this.getKeyAt(this.firstKeyRotation, n);
        if (keyAnim == null) {
            this.rotation.set(0.0, 0.0, 0.0);
            return;
        }
        KeyAnim keyAnim2 = keyAnim.getNextKey();
        KeyRotation keyRotation = (KeyRotation)keyAnim;
        if (keyAnim2 == null) {
            this.rotation.copy(keyRotation.getRotation());
            return;
        }
        KeyRotation keyRotation2 = (KeyRotation)keyAnim2;
        double d = keyAnim2.getTime() - keyAnim.getTime();
        double d2 = n - keyAnim.getTime();
        double d3 = 1.0 - d2 / d;
        Point3D point3D = keyRotation2.getRotation();
        Point3D point3D2 = keyRotation2.getAxis();
        double d4 = keyRotation2.getAngle() * d3;
        this.axis3D.init();
        this.axis3D.rotateX(point3D.x);
        this.axis3D.rotateZ(point3D.z);
        this.axis3D.rotateY(point3D.y);
        this.axis3D.rotate(-d4, point3D2.x, point3D2.y, point3D2.z);
        this.axis3D.getRotationXZY(this.rotation);
    }

    public void playPositionAt(int n) {
        KeyAnim keyAnim = this.getKeyAt(this.firstKeyPosition, n);
        if (keyAnim == null) {
            this.position.set(0.0, 0.0, 0.0);
            return;
        }
        KeyPosition keyPosition = (KeyPosition)keyAnim;
        this.position.copy(keyPosition.getPosition());
        KeyAnim keyAnim2 = keyAnim.getNextKey();
        if (keyAnim2 == null) {
            return;
        }
        KeyPosition keyPosition2 = (KeyPosition)keyAnim2;
        Point3D point3D = keyPosition2.getPosition();
        double d = keyAnim2.getTime() - keyAnim.getTime();
        double d2 = n - keyAnim.getTime();
        double d3 = d2 / d;
        double d4 = point3D.getX() - this.position.getX();
        double d5 = point3D.getY() - this.position.getY();
        double d6 = point3D.getZ() - this.position.getZ();
        this.position.add(d4 * d3, d5 * d3, d6 * d3);
    }

    public void playAt(int n) {
        this.playRotationAt(n);
        this.playPositionAt(n);
    }

    public void zoom(double d, double d2, double d3) {
        for (KeyPosition keyPosition = this.firstKeyPosition; keyPosition != null; keyPosition = (KeyPosition)keyPosition.getNextKey()) {
            keyPosition.getPosition().zoom(d, d2, d3);
        }
    }

    public IScene3DObjectAnimator getClone() {
        Scene3DObjectAnimator scene3DObjectAnimator = new Scene3DObjectAnimator();
        scene3DObjectAnimator.copy(this);
        return scene3DObjectAnimator;
    }

    public IPoint3D getPosition() {
        return this.position;
    }

    public IPoint3D getRotation() {
        return this.rotation;
    }

    public void copy(IScene3DObjectAnimator iScene3DObjectAnimator) {
        Scene3DObjectAnimator scene3DObjectAnimator = (Scene3DObjectAnimator)iScene3DObjectAnimator;
        for (KeyPosition keyPosition = scene3DObjectAnimator.firstKeyPosition; keyPosition != null; keyPosition = (KeyPosition)keyPosition.getNextKey()) {
            this.addKeyPosition(keyPosition.getTime(), keyPosition.getPosition().getClone());
        }
        for (KeyRotation keyRotation = scene3DObjectAnimator.firstKeyRotation; keyRotation != null; keyRotation = (KeyRotation)keyRotation.getNextKey()) {
            this.addKeyRotation(keyRotation.getTime(), keyRotation.getRotation().getClone(), keyRotation.getAxis().getClone(), keyRotation.getAngle());
        }
        for (KeyZoom keyZoom = scene3DObjectAnimator.firstKeyZoom; keyZoom != null; keyZoom = (KeyZoom)keyZoom.getNextKey()) {
            this.addKeyZoom(keyZoom.getTime(), keyZoom.getZoomStart().getClone(), keyZoom.getZoom().getClone());
        }
        this.position.copy(scene3DObjectAnimator.getPosition());
        this.rotation.copy(scene3DObjectAnimator.getRotation());
        this.timer = scene3DObjectAnimator.getTimer();
        this.startTime = scene3DObjectAnimator.getStartTime();
        this.endTime = scene3DObjectAnimator.endTime;
        this.loopAt = scene3DObjectAnimator.loopAt;
        this.pauseTime = scene3DObjectAnimator.getPauseTime();
    }

    class KeyZoom
    extends KeyAnim {
        public static final long serialVersionUID = 1L;
        private Point3D zoomStart;
        private Point3D zoom;

        KeyZoom(int n, Point3D point3D, Point3D point3D2) {
            super(n);
            this.zoomStart = point3D;
            this.zoom = point3D2;
        }

        public Point3D getZoomStart() {
            return this.zoom;
        }

        public Point3D getZoom() {
            return this.zoom;
        }
    }

    class KeyPosition
    extends KeyAnim {
        public static final long serialVersionUID = 1L;
        private Point3D position;

        KeyPosition(int n, Point3D point3D) {
            super(n);
            this.position = point3D;
        }

        public Point3D getPosition() {
            return this.position;
        }
    }

    class KeyRotation
    extends KeyAnim {
        public static final long serialVersionUID = 1L;
        private Point3D rotation;
        private Point3D axis;
        private double angle;

        KeyRotation(int n, Point3D point3D, Point3D point3D2, double d) {
            super(n);
            this.rotation = point3D;
            this.axis = point3D2;
            this.angle = d;
        }

        public Point3D getRotation() {
            return this.rotation;
        }

        public Point3D getAxis() {
            return this.axis;
        }

        public double getAngle() {
            return this.angle;
        }
    }

    class KeyAnim
    implements Serializable {
        public static final long serialVersionUID = 1L;
        private int keyTime;
        private KeyAnim nextKey;

        KeyAnim(int n) {
            this.keyTime = n;
            this.nextKey = null;
        }

        public int getTime() {
            return this.keyTime;
        }

        public KeyAnim getNextKey() {
            return this.nextKey;
        }

        public void setNextKey(KeyAnim keyAnim) {
            this.nextKey = keyAnim;
        }
    }
}

