/*
 * Decompiled with CFR 0.152.
 */
package net.dzzd.core;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import net.dzzd.access.IDirectInput;

public class DirectInput
implements IDirectInput,
MouseListener,
MouseMotionListener,
KeyListener {
    private int mousePosX;
    private int mousePosY;
    private int mousePosDragX;
    private int mousePosDragY;
    private boolean mouseB1;
    private boolean mouseB2;
    private boolean mouseB3;
    private long mouseB1Click;
    private long mouseB2Click;
    private long mouseB3Click;
    private boolean drag;
    private int[] keyboard = new int[1024];
    private long[] keyboardTime = new long[1024];

    public DirectInput(Component component) {
        for (int i = 0; i < this.keyboard.length; ++i) {
            this.keyboard[i] = 0;
            this.keyboardTime[i] = 0L;
        }
        this.drag = false;
        this.mouseB1 = false;
        this.mouseB2 = false;
        this.mouseB3 = false;
        this.mouseB1Click = 0L;
        this.mouseB2Click = 0L;
        this.mouseB3Click = 0L;
        component.addMouseMotionListener(this);
        component.addMouseListener(this);
        component.addKeyListener(this);
    }

    public int getMouseX() {
        return this.mousePosX;
    }

    public int getMouseY() {
        return this.mousePosY;
    }

    public boolean isMouseB1() {
        return this.mouseB1;
    }

    public boolean isMouseB1Click(long l) {
        return System.currentTimeMillis() - this.mouseB1Click < l;
    }

    public boolean isMouseB2Click(long l) {
        return System.currentTimeMillis() - this.mouseB2Click < l;
    }

    public boolean isMouseB3Click(long l) {
        return System.currentTimeMillis() - this.mouseB3Click < l;
    }

    public boolean isMouseB2() {
        return this.mouseB2;
    }

    public boolean isMouseB3() {
        return this.mouseB3;
    }

    public boolean isMouseDrag() {
        return this.drag;
    }

    public boolean isKey(int n) {
        return this.keyboard[n] == 1;
    }

    public boolean isKey(int n, long l) {
        return this.keyboard[n] == 1 && System.currentTimeMillis() - this.keyboardTime[n] < l;
    }

    public int getMouseDragX() {
        return this.mousePosDragX;
    }

    public int getMouseDragY() {
        return this.mousePosDragY;
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401) {
            this.keyPressed(keyEvent);
        }
        if (keyEvent.getID() == 402) {
            this.keyReleased(keyEvent);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.keyboardTime[keyEvent.getKeyCode() & 0x3FF] = System.currentTimeMillis();
        this.keyboard[keyEvent.getKeyCode() & 0x3FF] = 1;
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.keyboardTime[keyEvent.getKeyCode() & 0x3FF] = System.currentTimeMillis();
        this.keyboard[keyEvent.getKeyCode() & 0x3FF] = 0;
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void processMouseMotionEvent(MouseEvent mouseEvent) {
        this.mousePosX = mouseEvent.getX();
        this.mousePosY = mouseEvent.getY();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.mousePosX = mouseEvent.getX();
        this.mousePosY = mouseEvent.getY();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.drag = true;
        this.mousePosX = mouseEvent.getX();
        this.mousePosY = mouseEvent.getY();
        if (!this.drag) {
            this.mousePosDragX = this.mousePosX;
            this.mousePosDragY = this.mousePosY;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 0x10) != 0) {
            this.mouseB1Click = System.currentTimeMillis();
        }
        if ((mouseEvent.getModifiers() & 8) != 0) {
            this.mouseB2Click = System.currentTimeMillis();
        }
        if ((mouseEvent.getModifiers() & 4) != 0) {
            this.mouseB3Click = System.currentTimeMillis();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 0x10) != 0) {
            this.mouseB1 = true;
        }
        if ((mouseEvent.getModifiers() & 8) != 0) {
            this.mouseB2 = true;
        }
        if ((mouseEvent.getModifiers() & 4) != 0) {
            this.mouseB3 = true;
        }
        if (!this.drag) {
            this.mousePosDragX = this.mousePosX;
            this.mousePosDragY = this.mousePosY;
            this.drag = true;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 0x10) != 0) {
            this.mouseB1 = false;
        }
        if ((mouseEvent.getModifiers() & 8) != 0) {
            this.mouseB2 = false;
        }
        if ((mouseEvent.getModifiers() & 4) != 0) {
            this.mouseB3 = false;
        }
        if (this.drag) {
            this.drag = false;
        }
    }
}

