import dzzd.DzzD;
import dzzd.*;

public final class DzzDDemoApplet extends DzzDApplet implements IScene3DRenderCallBack
{

  	/**
     * Init 3DzzD 
     */
	public void init3DzzD()
	{
		String baseURL=this.getBaseURL();
		this.getScene3DRender().setScene3DRenderCallBack(this);
		loaded=false;
		
		this.getScene3DRender().getScene3D().loadScene3DFrom3DS(baseURL+"LEVEL/","LEVEL.3DS");
		this.getScene3DRender().getScene3D().loadScene3DFrom3DS(baseURL+"SKYBOX/","SKYBOX.3DS");

		//CREATE AN HEIGHTMAP USING A REMOTE FILE AS SOURCE
		IURLHeightMap ground=DzzD.newURLHeightMap();
		ground.load(baseURL+"TERRAIN/","TERRAIN.RAW",257,257);
		
		//LOAD TEXTURE FOR GROUND DIFFUSE COLOR
		IURLTexture texture=DzzD.newURLTexture();
		texture.load(baseURL+"TERRAIN/","SOL.JPG");
			
		//LOAD TEXTURE FOR GROUND DETAIL 	
		IURLTexture detail=DzzD.newURLTexture();
		detail.load(baseURL+"TERRAIN/","DETAIL.JPG");
		
		//CREATE MAPPING & MATERIAL FOR GROUND				
		IMappingUV mapping = DzzD.newMappingUV();
		IMaterial material = DzzD.newMaterial();
		
		//SET MAPPING TO MATERIAL
		material.setMappingUV(mapping);
		//mapping.setUZoom(100);
		//mapping.setVZoom(100);
		//SET MATERIAL PROPERTIES
		material.setDiffuseColor(0x00FF0000);
		material.setSpecularColor(0x00FFFFFF);
		material.setSpecularLevel(255);
		material.setSpecularPower(30);
		material.setDiffuseTexture(texture);
		material.setDiffuseTextureDetail(detail);
		material.setDiffuseTextureDetailFactor(-7);	//DETAIL TEXTURE IS 128 times smaller than mains diffuse
		
		//CREATE A HEIGHTMAP TESSELATOR WITH A MINIMUM LEVEL AND A MAXIMUM LEVEL OF 2(14+1)==32768 faces/subdivision max
		IHeightMap3D ground3D=DzzD.newHeightMap3D(0,14);
		
		//SET ITS SOURCE HEIGHTMAP
		ground3D.setHeightMap(ground);
		
		//SET GENERATED MESH 3D BOUNDS (MAXIMUM SIZE)
		ground3D.setMesh3DBounds(0,0,0,100000,100000,5000);
	//	ground3D.setFarClip(20000);

		//SET GENERATED QUALITY (NOT RELATED TO VIEW POS)
		ground3D.setMesh3DGeneratorQuality(0.0000009);
		
		//GENERATE A MESH
		IMesh3D mesh3d=ground3D.generate();
		
		//SET ITS PIVOT TO CENTER(X,Y)
		mesh3d.getPivot().set(50000,50000,0);
		
		//MOVE IT SO THAT BUILDING WILL BE IN A MORE FLAT AREA
		mesh3d.getPosition().set(2500,4520,-3500);
		
		//DRAW TOTAL NUMBER OF FACE
 		System.out.println("FACE="+ground3D.getNbFace3D());
		
		//SET QUALITY WHILE RENDERING (RELATED TO VIEW POS)
		ground3D.setMesh3DViewGeneratorQuality(0.000002);
		
		//SET ITS X AXIS ROTATION TO Math.PI*0.5
		mesh3d.getRotation().setX(-Math.PI*0.5);
		
		//DISABLE LIGHTING (NOT AVAILABLE FOR NOW)
		mesh3d.getRenderMode().disableRenderMode(DzzD.RM_LIGHT);

		//SET MATERIAL TO MESH
		mesh3d.setMaterial(material);
		
		//ADD MATERIAL AND MESH TO SCENE
		this.getScene3DRender().getScene3D().addMesh3D(mesh3d);
		this.getScene3DRender().getScene3D().addMaterial(material);
		
		//this.getScene3DRender().getScene3D().addTexture(texture);
		
		
	}
	
  	/**
     * Start 3DzzD 
     */
	public void start3DzzD()
	{
		
	}	

	boolean loaded;
	IScene3DObject cam;
	IPoint3D camRotation;
	IPoint3D camPosition;
	IAxis3D camAxis;
	double speed=10;
	double jetpack=5;
	double fuel;
	
	//CALLED WHEN AT LEAST ONE OBJECT IS LOADED OR WHEN AT LEAST ONE OBJECT IS FINISHED LOADING
	public void render3DObjectMonitor(IScene3DRender r)
	{
		//System.out.println(r.getScene3D().getNbMonitoredObject());
		if(r.getScene3D().getNbMonitoredObject()>0)
			return;
		
		//DRAW SCENE SUMMARY
		System.out.println("Nb Mesh="+r.getScene3D().getNbMesh3D());
		for(int nm=0;nm<r.getScene3D().getNbMesh3D();nm++)
			System.out.println(r.getScene3D().getMesh3DById(nm).getName()+":"+r.getScene3D().getMesh3DById(nm).getNbFace3D()+" ("+r.getScene3D().getMesh3DById(nm).getNbVertex3D()+")");
		System.out.println("Nb Light="+r.getScene3D().getNbLight3D());
		System.out.println("Nb Camera="+r.getScene3D().getNbCamera3D());
		
		//SELECT CURRENT CAMERA FOR RENDERING
		r.getScene3D().setCurrentCamera3DById(0);
		
		//SET CAMERA FOV
		r.getScene3D().getCamera3DById(0).setFOV(45);  
		
		//SET AN ID FOR SKY BOX	
		IMesh3D sky=r.getScene3D().getMesh3DByName("Sky");
		if(sky!=null)
			r.getScene3D().setSkyBoxMesh3DById(sky.getId());
		
		//GET CAMERA 0			
		this.cam=r.getScene3D().getCamera3DById(0);
		this.camRotation=cam.getRotation(); 
		this.camPosition=cam.getPosition();
		this.camAxis=cam.getAxis3D();	
		this.camPosition.set(0,200,0);
	
		
	//	((ICamera3D)cam).setZMax(300);
	//	r.getScene3D().setBackgroundColor(0x000000);
	
		loaded=true;
	}	
	
	
	//CALLED FOR EACH FRAME IN  WORLD SPACE
	int nbi=0;
	public void render3DWorldSpace(IScene3DRender r)
	{
		if(!loaded)
			return;
			
		IDirectInput di=r.getRender3D().getDirectInput();
		
		IPoint3D lr=r.getScene3D().getLight3DById(0).getRotation();
		lr.set(-0.8,lr.getY()+0.01,0);
			
		/*
			//Play a 3ds keyframe animation using the root object name
			r.setAutoPlayAnimator(true);
			if(di.isMouseB1())
				r.getScene3D().getMesh3DByName("ROBOTANI3.3DS").startScene3DObjectAnimator();
		*/


		//ROTATE USING MOUSE COORDINATE
		IPoint3D az=this.camAxis.getAZ();
		double rx=this.camRotation.getX(); 
		double ry=this.camRotation.getY();
		double mx=di.getMouseX();
		double my=di.getMouseY();
		this.camRotation.setY(ry+(r.getRender3D().getWidth()*0.5-mx)*4000.0/20000000.0);
		this.camRotation.setX(rx+(r.getRender3D().getHeight()*0.5-my)*3000.0/20000000.0);
		 
		//MOVE USING CAMERA Z AXIS IN WORLD SPACE 
		double mvx=0;
		double mvy=0;
		double mvz=0;
		if(di.isKey(38))
		{   
			mvx=az.getX()*speed;
			mvy=az.getY()*speed;
			mvz=az.getZ()*speed;
		}
		
		if(di.isKey(40))
		{   
			mvx=-az.getX()*speed;
			mvy=-az.getY()*speed;
			mvz=-az.getZ()*speed;
		}
		
		//MOVE STRAFF USING CAMERA X AXIS IN WORLD SPACE 
		double slide=speed*0.5;
		if(di.isKey(39))
		{   
			IPoint3D ax=camAxis.getAX();
			mvx=mvx+ax.getX()*slide;
			mvy=mvy+ax.getY()*slide;
			mvz=mvz+ax.getZ()*slide;
		}
		
		if(di.isKey(37))
		{   
			IPoint3D ax=camAxis.getAX();
			mvx=mvx-ax.getX()*slide;
			mvy=mvy-ax.getY()*slide;
			mvz=mvz-ax.getZ()*slide;
		}

		/*
 		//MOVE WITHOUT GRAVITY AND COLLISION
		double cx=camPosition.getX();
		double cy=camPosition.getY();
		double cz=camPosition.getZ();
		camPosition.setX(cx+mvx);
		//camPosition.setY(120);//cy+mvy);
		camPosition.setY(cy+mvy);
		camPosition.setZ(cz+mvz);
		*/


		
		if(di.isMouseB3())
		{
			jetpack=fuel;
			if(fuel>0)	
				fuel-=0.3;
			
		}
		else
		{
			if(fuel<40)
				fuel+=0.1;
			jetpack=0;
			speed=15;
		}
		speed=15+15*fuel/40;
		
		//MOVE CAMERA AS A SOLID SPHERE AND ADD A GRAVITY VECTOR
		cam.setSphereBox(70);
		cam.moveAsSolidSphere(mvx,(mvy-10)+jetpack,mvz,0,5);
	

	}
	
	public void render3DstartCallBack(IScene3DRender r){}
	public void render3DStart(IScene3DRender r){}
	public void render3DCameraSpace(IScene3DRender r){}
	public void render3DPixelsUpdate(IScene3DRender r){}
	public void render3DPixelsUpdated(IScene3DRender r){}	
	public void render3DEnd(IScene3DRender r){}		
}
